-- Robik extend
-- 20:01:2014
-- Lisica
-- Keeper
-- V 2.90
--   Solegstar
library IEEE; 
use IEEE.std_logic_1164.all; 
use IEEE.std_logic_unsigned.all;
use IEEE.numeric_std.ALL;  
entity extend is                    
port(

f14				:in std_logic;
f8				:in std_logic;
turbo			:in std_logic;
----------------Z80----------------------
reset			:in std_logic;
wr				:in std_logic;
rd				:in std_logic;
iorq			:in std_logic;
iorqge			:out std_logic;
m1				:in std_logic;
mrq				:in std_logic;
nmi				:buffer std_logic;
w_a_i_t			:buffer std_logic;
adress			:in std_logic_vector(15 downto 0);
Data			:inout std_logic_vector(7 downto 0);

----ZSpi--
SD_CLK			:buffer std_logic;
SD_DAT0			:in std_logic;
SD_DAT3			:out std_logic;
SD_CMD			:out std_logic;

-----------------AY------------------------
bc1a			:out std_logic;
bc1b			:out std_logic;
bdira			:out std_logic;
bdirb			:out std_logic;
ay_clk			:out std_logic;

----------------BDI------------------------
joy				:out std_logic;
dos				:buffer std_logic;
sel_dos			:in std_logic;
magik			:in std_logic;
------------------WG93-------------------------------------
wg_clk:			out std_logic;
cswg:			buffer std_logic;
disk0:			out std_logic;
disk1:			out std_logic;
rst:			out std_logic;
hlt:			out std_logic;
side1:			out std_logic;
dden:			out std_logic;

rclk			:buffer std_logic;
wf_de			:in std_logic;
rawr			:buffer std_logic;

tr43			:in std_logic;
sr				:in std_logic;
sl				:in std_logic;
wd				:in std_logic;
intr			:in std_logic;
drq				:in std_logic;

motor			:in std_logic;
rdat			:in std_logic;
wdat			:out std_logic;

---------------cmos------------------
ds_cmos			:out std_logic;
rw_cmos			:out std_logic;
as_cmos			:out std_logic;
ce_cmos			:buffer std_logic;

sel_128			:out std_logic;


---------------mouse------------------
AP6				:buffer std_logic;
ATT_6			:buffer std_logic
);
end extend;

architecture extend_arch of extend is

---------------------------------------------------------------------------
COMPONENT SPI               
    port(
        --INPUTS
        DI      : in std_logic_vector(7 downto 0);
        CLC     : in std_logic;
        MISO    : in std_logic;
        START   : in std_logic;
        WR_EN   : in std_logic;
        --OUTPUTS
        DO      : out std_logic_vector(7 downto 0);
        SCK     : out std_logic;
        MOSI    : out std_logic
        );
END COMPONENT ;
---------------------------------------------------------------------------
--signal adress			:std_logic_vector(15 downto 0);

------reset----- 
signal res:				std_logic;
-----------DOS-------------
signal dos_on:			std_logic;
signal dos_of:			std_logic;
signal pzu:				std_logic;
signal mem:				std_logic;
signal mag:				std_logic;
signal fwait:			std_logic_vector(1 downto 0);
signal mwait:			std_logic_vector(1 downto 0);
signal rwait:			std_logic_vector(12 downto 0);
signal csff:			std_logic;
signal pff:				std_logic_vector(7 downto 0);
signal csfd:			std_logic;
signal pfd:				std_logic_vector(1 downto 0);

------------FAPCH-------------
signal f:				std_logic_vector(6 downto 0);
signal f1:				std_logic;
signal f4:				std_logic;
signal clk_wg:			std_logic;
signal rdat1:			std_logic;
signal fa:				std_logic_vector(4 downto 0);
signal rd1:				std_logic;
signal rd2:				std_logic;

--------------
signal	wdata: 			std_logic_vector(3 downto 0);

----------------TurboSound---------------
signal del_ay:			std_logic_vector(2 downto 0);
signal trst:			std_logic;
signal bc1:				std_logic;
signal bdir:			std_logic;
signal csts:			std_logic;

------------------Clock-----------------
signal cseff7:			std_logic;
signal peff7:			std_logic_vector(7 downto 0);

-----------------ZXspi-----------------
signal z_data:			std_logic_vector(7 downto 0);
signal spi_start:		std_logic;
signal wr_en:			std_logic;
signal port77_wr:		std_logic;
signal nSDCS:			std_logic;
signal spi_iorqge:		std_logic;
signal SD_CLK1:			std_logic;

---------------------------------------------------------
signal f14_m:			std_logic;
signal f82:				std_logic;
signal f83:				std_logic;
signal w1:				std_logic;
signal w2:				std_logic;
signal w_a_i_t1:		std_logic;
signal w_a_i_t2:		std_logic;
signal w_a_i_t3:		std_logic;

begin

---------------------w_a_i_t-----------------------------
process(iorq,fwait)
begin
if (fwait(1) = '0' and turbo = '0') or res = '0' then
	w_a_i_t1 <= '1';
	elsif (iorq'event and iorq = '0') then
		if turbo = '0' then
		w_a_i_t1 <= '0';	
		end if;
	end if;
end process;	


process(fwait,f14,iorq)
begin 
if (del_ay(1)'event and del_ay(1) = '1') then
	fwait(0) <= iorq;
	fwait(1) <= fwait (0);
end if;
end process;	

------------  ~1   ------------
process(rwait,reset)
begin
if rwait = 8191  then
	w_a_i_t2 <= '1';
	elsif (reset'event and reset = '1') then
		w_a_i_t2 <= '0';	
	end if;
end process;	

process(fwait,del_ay,iorq)
begin
if w_a_i_t2 = '1' or reset = '0' then
	rwait <= "0000000000000"; 
	elsif (f(6)'event and f(6) = '0') then
	rwait <= rwait +1;
end if;
end process;	
w_a_i_t <= '0' when w_a_i_t3 = '0' or w_a_i_t2 = '0' or w_a_i_t1 = '0' else 'Z';

process(reset)
begin 
if res = '0' then
	res <= '1';
elsif (reset'event and reset='0') then
	res <= '0';
end if;
end process;	

------------------------- ---------------------
pzu <= adress(15) or adress(14);
mem <= m1 or mrq;
dos_on <= '1' when (adress(15 downto 8) = "00111101" and mem = '0' and pfd(0) = '1') or (mag = '0') else '0';
dos_of <= not pzu or mem;
csff <= '1' when (dos = '0' and adress(7) = '1' and iorq = '0') else '0';
cswg <= '0' when (dos = '0' and adress(7) = '0' and iorq = '0') else '1';
disk0 <= '0' when pff(1 downto 0) = "00" and motor = '1' else 'Z';
disk1 <= '0' when pff(1 downto 0) = "01" and motor = '1' else 'Z';
mag <= '0' when magik = '0' and mem = '0' and pzu = '1' else '1';
nmi <= '0' when mag = '0' else 'Z';
joy <= '0' when (adress(7 downto 0) = "00011111" and dos = '1' and iorq = '0' and rd = '0' and m1 = '1') else '1';
iorqge <= spi_iorqge or not dos or peff7(7) or not ATT_6;
csfd <= '1' when adress(15) = '0' and adress(1) = '0' and wr = '0' and iorq = '0' and m1 = '1' else '0';

--------------------------------------------------------------

---------------------------------------------------------

process(f14,adress,rd,iorq,m1,spi_iorqge)
begin
if ( f14'event and f14 = '1') then
	if adress(7 downto 0) = "11011111" and iorq = '0' and m1 = '1' and spi_iorqge = '0' then
	ATT_6 <= '0';
	else ATT_6 <= '1';
	end if;
end if;
end process;	

process(f14,ATT_6,rd,iorq,spi_iorqge,peff7)
begin
if ( f14'event and f14 = '1') then
	if ATT_6 = '0' and rd = '0' and wr = '1' and spi_iorqge = '0' and peff7(7) = '0' then
	AP6 <= '0';
	else
	AP6 <= '1';
	end if;
end if;
end process;	

process(ATT_6,mwait)
begin
if mwait(1) = '0' or res = '0' then
	w_a_i_t3 <= '1';
	elsif (AP6'event and AP6 = '0') then
		w_a_i_t3 <= '0';	
	end if;
end process;	

process(fwait,del_ay,iorq)
begin 
if (del_ay(2)'event and del_ay(2) = '1') then
	mwait(0) <= AP6;
	mwait(1) <= mwait (0);
end if;
end process;	

----------------port 7FFD------------------

process(f14,pfd,Data,wr,csfd)
begin 
if res = '0' then
	pfd <= "01";
	elsif (f14'event and f14 = '1') then
	if csfd = '1' and ((pfd(1) = '0' and peff7(2) = '0') or (pfd(1) = '0' and peff7(2) = '1')) then
	pfd <= Data(5 downto 4);
	end if;
end if;
end process;	

----------------port ff to WG93------------------------------
process(f14,pff,Data,wr,csff)
begin 
if res = '0' then
	pff(7 downto 0) <= "00000000";
	elsif (f14'event and f14 = '1') then
	if csff = '1' and wr = '0' then
	pff <= Data;
	end if;
end if;
end process;	

dden <= pff(6);
side1 <= not pff(4);
hlt <= pff(3);
rst <= pff(2);
sel_128 <= not peff7(2);

process(dos_of,dos_on,f14)
begin
if reset = '0' then
	dos <= sel_dos;
	elsif ( f14'event and f14 = '1') then
		if dos_of = '0' then
		dos <= '1';
		end if;
		if dos_on = '1' then
		dos <= '0';
		end if;
end if;
end process;	

-----------------FAPCH------------------------------------------------------
process(f8,f)
begin
if (f8'event and f8='0') then------ 8->4->1 
	f <= f + 1;
end if;
end process;	

f4 <= f(0);---------  
wg_clk <= f(2);-----  93 (1)	

------------------------------ RAWR 125 
process(f8,rdat,rd1)
begin
if (f8'event and f8='1') then
	rd1 <= rdat;
end if;
end process;

process(f8,rd1,rd2)
begin
if (f8'event and f8='1') then
	rd2 <= not rd1;
end if;
end process;
rawr <= '0' when wf_de = '0' and (rd1 = '1' and rd2 = '1') else '1';-- RAWR ,  WF_DE - '1' -   
-------------------------------------------------------------

-----------------  (  RCLK)
process(f8,rawr,fa)
begin
if (f8'event and f8='1') then
	if rawr = '0' then
		if fa(3 downto 0) < 3 then
		fa(3 downto 0) <= fa(3 downto 0) + 4;
		elsif fa(3 downto 0) < 5 then
		fa(3 downto 0) <= fa(3 downto 0) + 3;
		elsif fa(3 downto 0) < 7 then
		fa(3 downto 0) <= fa(3 downto 0) + 2;
		elsif fa(3 downto 0) = 7 then
		fa(3 downto 0) <= fa(3 downto 0) + 1;
		elsif fa(3 downto 0) > 12 then
		fa(3 downto 0) <= fa(3 downto 0) - 3;
		elsif fa(3 downto 0) > 9 then
		fa(3 downto 0) <= fa(3 downto 0) - 2;
		elsif fa(3 downto 0) > 8 then
		fa(3 downto 0) <= fa(3 downto 0) - 1;
		end if;
		else
		fa <= fa +1;
	end if;
end if;
end process;

process(f8,rclk)
begin
if wf_de = '0' then--, RCLK      (    RAWR)
		rclk <= not fa(4);
		else rclk <= '1';
end if;
end process;

---------------- ---------------------------------------------
wdat <= wdata(3);
process(f4,wd,tr43,sr,sl)
begin
if (f4'event and f4 = '1') then
	if (wd = '1') then
	wdata(0) <= tr43 and sr;
	wdata(1) <= not ((tr43 and sr) or (tr43 and sl));
	wdata(2) <= tr43 and sl;
	wdata(3) <= '0';
	else
	wdata(3) <= wdata(2);
	wdata(2) <= wdata(1);
	wdata(1) <= wdata(0);
	wdata(0) <= '0';
end if;
end if;
end process;

---------------------AY-----------------------

process(f14,del_ay)
begin
if (f14'event and f14='1') then
	del_ay <= del_ay + 1;
	ay_clk <= del_ay(2);
end if;
end process;

process(f14,trst,res,csts)
begin
if (f14'event and f14 = '1') then
	if (bc1 = '1' and trst = '0') then
		bc1a <='1'; else bc1a <='0';
	end if;
	if (bc1 = '1' and trst = '1') then
		bc1b <='1';else bc1b <='0';
	end if;
	if (bdir = '1' and trst = '0') then
		bdira <='1'; else bdira <='0';
	end if;
	if (bdir = '1' and trst = '1') then
		bdirb <='1'; else bdirb <='0';
	end if;
end if;
end process;

bc1 <= '1' when m1 = '1' and iorq = '0' and adress(15 downto 14) = "11" and adress(1 downto 0) = "01" and adress(8) = '1' else '0';
bdir <= '1' when m1 = '1' and iorq = '0' and wr = '0' and adress(15) = '1' and adress(1 downto 0) = "01" else '0';

csts <= '0' when (Data(7 downto 1) = "1111111" and BC1='1' and BDIR='1') else '1';

process(f14,trst,res,csts)
begin
if (res = '0') then
	trst <= '0';
	elsif ((f14'event and f14='1') and csts = '0') then
	trst <= not Data(0);
end if;
end process;

---------------------------------------------Cmos--------------------------------------------
cseff7<='1' when (adress=61431 and wr='0' and iorq = '0' and m1 = '1') else '0';
ds_cmos<='0' when (adress=49143 and iorq='0' and m1 = '1' and rd = '0') else '1';
rw_cmos<='0' when (adress=49143 and iorq='0' and m1 = '1' and wr = '0') else '1';
as_cmos<='1' when (adress=57335 and iorq='0' and m1 = '1' and  wr = '0') else '0';
ce_cmos	<= '0' when peff7(7) = '1' and spi_iorqge = '0' and dos = '1' and bc1 = '0' and bdir = '0' and AP6 = '1' else 'Z';

process(res,cseff7,f14,peff7)
begin
if (res = '0') then
	peff7 <= "00000000";
	elsif (f14'event and f14 = '1') then
		if cseff7 = '1' then
			if pfd(1) = '1' and peff7(2) = '1' then
			peff7(7 downto 3) <= Data(7 downto 3);
			peff7(1 downto 0) <= Data(1 downto 0);
			else
			peff7 <= Data;
			end if;
		end if;
end if;
end process;

------------------------DATA-----------------------------

process(f14,Data,csff,z_data,rd,wr,iorq,intr,drq)
begin
if csff = '1' and rd = '0' and wr = '1' then
	Data(7 downto 0) <= intr & drq & "111111";
	elsif (adress(7 downto 0) = X"57" and iorq = '0' and rd = '0' and wr = '1') then
	Data(7 downto 0)<=z_data(7 downto 0);
	elsif (adress(7 downto 0) = X"77" and iorq = '0' and rd = '0' and wr = '1') then
	Data<="11111100";
	else
	Data<="ZZZZZZZZ"; 
end if; 
end process;

-------------------------------------zcspi---------------------------------------------------
spi_start <= '1' when adress(7 downto 0) = X"57" and iorq = '0' and m1 = '1' and ce_cmos = '1' else '0';
wr_en <= '1' when adress(7 downto 0) = X"57" and iorq = '0' and m1 = '1' and wr = '0' and ce_cmos = '1' else '0';
port77_wr <= '1' when adress(7 downto 0) = X"77" and iorq = '0' and m1 = '1' and wr = '0' and ce_cmos = '1' else '0';
SD_DAT3 <= nSDCS;
spi_iorqge <= '1' when (adress(7 downto 0) = X"57" and iorq = '0' and m1 = '1') or (adress(7 downto 0) = X"77" and iorq = '0' and m1 = '1') else '0';
process (port77_wr, reset)
begin
if res = '0' then
	nSDCS <= '1';
elsif (port77_wr'event and port77_wr='0') then
	nSDCS <= Data(1);
end if;
end process;

------------------------------------------------------------------------------

zcspi_unit: SPI     -- SD
port map(
	DI				=> Data,
	START			=> spi_start,
	WR_EN			=> wr_en,
	CLC     		=> f14,                
	MISO    		=> SD_DAT0,
	DO				=> z_data,
	SCK     		=> SD_CLK,
	MOSI    		=> SD_CMD
);

end extend_arch;